<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Add UDP Port</title>
<link rel="stylesheet" type="text/css" href="../style/default.css" />
<script type="text/javascript" src="../js/jquery-1.8.3.min.js"></script>
<script type="text/javascript" src="../js/browserdetect.js"></script>
<script type="text/javascript" src="../js/smsx_common.js"></script>
<script type="text/javascript" src="../js/system_add_udp.js"></script>
<style type="text/css">
.header
{
	border-top: 0;
}
.body_width
{
	width: 500px;
}
.tab_width
{
	width: 480px;
}
.tableContainer input[type=text]
{
	width: 117px;
	text-align: center;
}
.tableContainer select
{
	width: 120px;
	height: 22px;
}
.button
{
	height:24px;
	text-align: center;
	margin-top: 10px;
}
.button input
{
	width: 70px;
	height: 24px;
	text-align: center;
	line-height: 24px;
	font-size: 12px;
	font-weight: bold;
	color: #1584C4;
	border-style:none;
	cursor: pointer;
	background: url(../images/btn2_normal.png);
}
.pid_map_table td
{
	width: 60px;
}
</style>
</head>

<body>
<input type="hidden" id="language" value="1" />
<div class="body_div body_width">
  <input type="checkbox" id="batchUdpCheckbox" checked="checked" />
  UDP端口批量设置
  <input type="checkbox" id="batchPidCheckbox" />
  PID映射批量设置 <div class="table_tab_div">
    <div class="table_tab_left"></div>
    <div class="table_tab tab_width">批量设置范围</div>
    <div class="table_tab_right"></div>
  </div>
  <div class="tableContainer">
    <table cellpadding="0" cellspacing="0" style="width:100%;">
      <tr>
        <th class="header" style="width:120px;">起始卡</th>
        <td class="header">
          <select id="beginCard">
            <option value="0" selected="selected">卡1</option>
            <option value="1">卡2</option>
            <option value="2">卡3</option>
            <option value="3">卡4</option>
          </select>
        </td>
        <th class="header" style="width:120px;">结束卡</th>
        <td class="header">
          <select id="endCard">
            <option value="0" selected="selected">卡1</option>
            <option value="1">卡2</option>
            <option value="2">卡3</option>
            <option value="3">卡4</option>
          </select>
        </td>
      </tr>
      <tr>
        <th class="header" style="width:120px;">起始RF端口</th>
        <td class="header">
          <select id="beginRfPort">
          </select>
        </td>
        <th class="header" style="width:120px;">结束RF端口</th>
        <td class="header">
          <select id="endRfPort">
          </select>
        </td>
      </tr>
      <tr>
        <th>起始频点(RF内)</th>
        <td>
          <input type="text" id="beginChannel" value="1" />
        </td>
        <th>结束频点(RF内)</th>
        <td>
          <input type="text" id="endChannel" value="1" />
        </td>
      </tr>
    </table>
  </div>
  <div id="udpBatchTable">
    <div class="table_tab_div">
      <div class="table_tab_left"></div>
      <div class="table_tab tab_width">UDP端口参数<font style="font-weight: normal; font-size: 10px;">(说明：&lt;配置个数&gt;为一个频点内的UDP端口个数。)</font></div>
      <div class="table_tab_right"></div>
    </div>
    <div class="tableContainer">
      <table cellpadding="0" cellspacing="0" style="width:100%;">
        <tr>
          <th class="header">配置个数</th>
          <td colspan="3" class="header">
            <input type="text" id="addUdpNumber" style="width: 98%; text-align:left;" value="10"/>
          </td>
        </tr>
        <tr>
          <th style="width: 120px;">参数</th>
          <th style="width: 122px;">起始值</th>
          <th>UDP端口间增量</th>
          <th>频点间增量</th>
        </tr>
        <tr>
          <th>目的IP地址</th>
          <td>
            <input type="text" id="destIpBegin" value="0.0.0.0" />
          </td>
          <td>
            <input type="text" id="destIpLineStep" value="0" />
          </td>
          <td>
            <input type="text" id="destIpChanStep" value="0" />
          </td>
        </tr>
        <tr>
          <th>UDP端口</th>
          <td>
            <input type="text" id="udpPortBegin" value="49156" />
          </td>
          <td>
            <input type="text" id="udpPortLineStep" value="2" />
          </td>
          <td>
            <input type="text" id="udpPortChanStep" value="256" />
          </td>
        </tr>
        <tr class="udp_set_param_tr">
          <th>端口开关</th>
          <td>
            <select id="portSwitch">
              <option value="0" selected="selected">关闭</option>
              <option value="1">打开</option>
              <option value="50">删除</option>
            </select>
          </td>
          <td></td>
          <td></td>
        </tr>
        <tr>
          <th>网络端口组</th>
          <td>
            <select id="networkPortGroup">
            </select>
          </td>
          <td></td>
          <td></td>
        </tr>
        <tr>
          <th>通道号</th>
          <td>
            <select id="channelNo">
              <option value="0" selected="selected">通道1</option>
              <option value="1">通道2</option>
            </select>
          </td>
          <td></td>
          <td></td>
        </tr>
        <tr class="udp_set_param_tr">
          <th>流类型</th>
          <td>
            <select id="streamType">
              <option value="0" selected="selected">Normal</option>
              <option value="1">DataP</option>
              <option value="2">DataR</option>
              <option value="3">Data</option>
            </select>
          </td>
          <td></td>
          <td></td>
        </tr>
        <tr class="udp_set_param_tr">
          <th>备份使能</th>
          <td>
            <select id="backupEnable">
              <option value="1">是</option>
              <option value="0" selected="selected">否</option>
            </select>
          </td>
          <td></td>
          <td></td>
        </tr>
        <tr class="udp_set_param_tr">
          <th>备份UDP端口</th>
          <td>
            <input type="text" id="backupUdpPort" value="0" />
          </td>
          <td></td>
          <td></td>
        </tr>
        <tr class="udp_set_param_tr">
          <th>输入节目号</th>
          <td>
            <input type="text" id="inServiceId" value="0" />
          </td>
          <td>
            <input type="text" id="inServiceIdLineStep" value="0" />
          </td>
          <td></td>
        </tr>
        <tr class="udp_set_param_tr">
          <th>输出节目号</th>
          <td>
            <input type="text" id="outServiceId" value="2" />
          </td>
          <td>
            <input type="text" id="outServiceIdLineStep" value="1" />
          </td>
          <td></td>
        </tr>
        <tr class="udp_set_param_tr">
          <th>PMV</th>
          <td>
            <input type="text" id="pmv" value="2" />
          </td>
          <td>
            <input type="text" id="pmvLineStep" value="1" />
          </td>
          <td></td>
        </tr>
        <tr class="udp_set_param_tr">
          <th>码率调整使能</th>
          <td>
            <select id="dtsAdjust">
              <option value="0" selected="selected">否</option>
              <option value="1">是</option>
            </select>
          </td>
          <td></td>
          <td></td>
        </tr>
        <tr class="udp_set_param_tr">
          <th>调整码率(Kbps)</th>
          <td>
            <input type="text" id="adjustBitrate" value="0" />
          </td>
          <td></td>
          <td></td>
        </tr>
        <tr class="udp_set_param_tr">
          <th>切换码率(Kbps)</th>
          <td>
            <input type="text" id="switchBitrate" value="0" />
          </td>
          <td></td>
          <td></td>
        </tr>
        <tr class="udp_set_param_tr">
          <th>缓存大小(Kbps)</th>
          <td>
            <input type="text" id="bufferSize" value="0" />
          </td>
          <td></td>
          <td></td>
        </tr>
        <tr class="udp_set_param_tr">
          <th><input type="checkbox" id="modeCheck" value="0" style="vertical-align:middle; margin-top:0" />模式</th>
          <td>
            <select id="mode" disabled>
              <option value="0" selected="selected">透传</option>
              <option value="1">过滤</option>           
            </select>
          </td>
          <td></td>
          <td></td>
        </tr>
        <tr class="udp_set_param_tr">
          <th>源IP</th>
          <td>
            <input type="text" id="sourceIp" value="0.0.0.0" />
          </td>
          <td></td>
          <td></td>
        </tr>      
      </table>
    </div>
  </div>
  <div id="pidBatchTable" style="display: none;">
    <div class="table_tab_div">
      <div class="table_tab_left"></div>
      <div class="table_tab tab_width">PID映射(双击编辑)</div>
      <div class="table_tab_right"></div>
    </div>
    <div class="tableContainer">
      <table class="pid_map_table" id="pidMapTable1">
        <tr>
          <td>-</td>
          <td>-</td>
          <td>-</td>
          <td>-</td>
          <td>-</td>
          <td>-</td>
          <td>-</td>
          <td>-</td>
        </tr>
        <tr>
          <td>-</td>
          <td>-</td>
          <td>-</td>
          <td>-</td>
          <td>-</td>
          <td>-</td>
          <td>-</td>
          <td>-</td>
        </tr>
      </table>
    </div>
    <div class="table_tab_div">
      <div class="table_tab_left"></div>
      <div class="table_tab tab_width">PID映射(双击编辑)</div>
      <div class="table_tab_right"></div>
    </div>
    <div class="tableContainer">
      <table class="pid_map_table" id="pidMapTable2">
        <tr>
          <td>-</td>
          <td>-</td>
          <td>-</td>
          <td>-</td>
          <td>-</td>
          <td>-</td>
          <td>-</td>
          <td>-</td>
        </tr>
        <tr>
          <td>-</td>
          <td>-</td>
          <td>-</td>
          <td>-</td>
          <td>-</td>
          <td>-</td>
          <td>-</td>
          <td>-</td>
        </tr>
      </table>
    </div>
  </div>
  <div class="button">
    <input type="button" value="设置" id="Apply" onclick="batchAddApply();this.style.background = 'url(../images/btn2_normal.png)';"
		hidefocus="true" onmouseover="mouseOverNormal(this);" onmouseout="mouseOutNormal(this);" />
    <input type="button" style="margin-left:8px;" value="刷新" id="Reset" onclick="pageRefresh();this.style.background = 'url(../images/btn2_normal.png)';" 
		hidefocus="true" onmouseover="mouseOverNormal(this);" onmouseout="mouseOutNormal(this);" />
  </div>
</div>
</body>
</html>
